// AcMapFlatOrclApiTestImportDlg.cpp : implementation file
//
///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Hugues Wisniewski, June 2001
//
// DESCRIPTION:
// 	Implementation of class AcMapFlatOrclApiTestImportDlg

#include "stdafx.h"
#include "AcMapFlatOrclApiTestImportDlg.h"
#include "AcMapFlatOrclApiTestConnectDlg.h"
#include "AcMapFlatOrclApiTestLoadQueryDlg.h"
#include "AcMapFlatOrclApiTestDisplayTextDlg.h"
#include "AcMapFlatOrclApiTestViewSqlDlg.h"
#include "AdMapOracleConnection.h"
#include "AdMapOracleQuery.h"
#include "AdMapOracleImport.h"
#include "AcMapFlatOrclApiTestTools.h"
#include "AcMapFlatOrclApiTestDescribeTableDlg.h"
#include <tchar.h>					//for _tcsupr
#include <vector>
#include <string>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AcMapFlatOrclApiTestImportDlg dialog


//******************************************************************************************
AcMapFlatOrclApiTestImportDlg::AcMapFlatOrclApiTestImportDlg(CWnd* pParent /*=NULL*/)
	: CDialog(AcMapFlatOrclApiTestImportDlg::IDD, pParent),
	m_strSelect("select ... \nfrom %s.ADMP... TableAlias\nwhere")
{
	//{{AFX_DATA_INIT(AcMapFlatOrclApiTestImportDlg)
	m_strEditWhereClause = _T("");
	m_nIdConditionSample = -1;
	m_strSelectFromWhere = _T("");
	m_strServiceSchema = _T("");
	m_strTableName = _T("");
	//}}AFX_DATA_INIT
}


//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AcMapFlatOrclApiTestImportDlg)
	DDX_Control(pDX, IDC_LIST_FEATURES, m_listFeatures);
	DDX_Control(pDX, IDC_LIST_CONDITION_SAMPLES, m_listConditionSamples);
	DDX_Control(pDX, IDC_EDIT_WHERE_CLAUSE, m_editWhereClause);
	DDX_Text(pDX, IDC_EDIT_WHERE_CLAUSE, m_strEditWhereClause);
	DDX_LBIndex(pDX, IDC_LIST_CONDITION_SAMPLES, m_nIdConditionSample);
	DDX_Text(pDX, IDC_STATIC_SELECT_FROM, m_strSelectFromWhere);
	DDX_Text(pDX, IDC_STATIC_SERVICE_SCHEMA, m_strServiceSchema);
	DDX_Text(pDX, IDC_EDIT_TABLENAME, m_strTableName);
	//}}AFX_DATA_MAP
}


//******************************************************************************************
BEGIN_MESSAGE_MAP(AcMapFlatOrclApiTestImportDlg, CDialog)
	//{{AFX_MSG_MAP(AcMapFlatOrclApiTestImportDlg)
	ON_BN_CLICKED(IDC_BTN_CONNECT, OnBtnConnect)
	ON_BN_CLICKED(IDC_BTN_LOAD_QUERY, OnBtnLoadQuery)
	ON_BN_CLICKED(IDC_BTN_SAVE_QUERY, OnBtnSaveQuery)
	ON_BN_CLICKED(IDC_BTN_VIEW_SQL, OnBtnViewSql)
	ON_LBN_SELCHANGE(IDC_LIST_CONDITION_SAMPLES, OnSelchangeListOdCondition)
	ON_BN_CLICKED(IDC_BTN_DESCRIBE_OD_TABLE, OnBtnDescribeOdTable)
	ON_BN_CLICKED(IDC_BTN_FEATURE_ALIASES, OnBtnFeatureAliases)
	ON_LBN_SELCHANGE(IDC_LIST_FEATURES, OnSelchangeListFeatures)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AcMapFlatOrclApiTestImportDlg message handlers

//******************************************************************************************
BOOL AcMapFlatOrclApiTestImportDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	//read all the samples and fill local string vectors
	if (!AcMapFlatOrclApiTestTools::ReadAllSampleSqlWhereClauses(
		m_vectSqlWhereClauses,
		m_vectSqlWhereClausesTitles))
	{
		EndDialog(IDCANCEL);
		return false;
	}

	m_editWhereClause.SetTabStops(10);

	//fill the list box with sample titles
	for (int i=0; i<m_vectSqlWhereClausesTitles.size(); i++)
	{
		m_listConditionSamples.AddString((const char*)m_vectSqlWhereClausesTitles[i]);
	}

	//read the current query if it exists
	if (AcMapOSEGetConnection()->IsConnected())
	{
		AcMapOSEQuery query(*AcMapOSEGetConnection());
		query.InitWithCurrent();
		std::string strQuery;
		strQuery=query.ConvertToSqlString();

		//we need to check if there is a where clause
		int nPosWhere=strQuery.find("where ");
		m_nIdConditionSample=0;

		//if where clause there is a current query that we display
		//in a separate dialog box to the user
		//we cannot initialse the present UI as there is only one edit control
		//for the where clause
		//The current query may have many features in it and each one may have custom 
		//conditions that we would be unable to display here
		if (std::string::npos!=nPosWhere)
		{
			AcMapFlatOrclApiTestViewSqlDlg Dlg("Current SQL Statement", strQuery);
			Dlg.DoModal();
			m_nIdConditionSample=-1;
		}
	}
	else
	{
		m_nIdConditionSample=0;
	}


	UpdateServiceSchema();
	UpdateControls();
	UpdateData(false);

	//if not initialized with current query because no current query
	if (0==m_nIdConditionSample)
	{
		OnSelchangeListOdCondition();
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::UpdateServiceSchema()
{
	AcMapOSEConnection *pConnection=AcMapOSEGetConnection();

	m_listFeatures.ResetContent();

	//if we rare connected we display the current service and schema
	if (pConnection->IsConnected())
	{
		m_strServiceSchema.Format(
			"Service: %s\nSchema: %s",
			pConnection->Service(),
			pConnection->UserName());
		m_strSelectFromWhere.Format(
			m_strSelect.c_str(),
			pConnection->UserName());

		//fills the list of feature names in the current schema
		std::vector<std::string> vectFeaturesNames;
		AcMapOSEGetConnection()->Features(vectFeaturesNames);
		for (int i=0; i<vectFeaturesNames.size(); ++i)
		{
			m_listFeatures.AddString(vectFeaturesNames[i].c_str());
		}
	}
	//if not connected we inform the user
	else
	{
		m_strServiceSchema="Not connected to Oracle";
		m_strEditWhereClause="";
		m_strSelectFromWhere.Format(
			m_strSelect.c_str(),
			"schema");
	}
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::UpdateControls()
{
	AcMapOSEConnection *pConnection=AcMapOSEGetConnection();

	//state of the controls depend on the state of the connexion
	if (pConnection->IsConnected())
	{
		GetDlgItem(IDC_STATIC_CONDITION_SAMPLES)->EnableWindow(true);
		GetDlgItem(IDC_LIST_CONDITION_SAMPLES)->EnableWindow(true);
		GetDlgItem(IDC_STATIC_WHERE_CLAUSE)->EnableWindow(true);
		GetDlgItem(IDC_STATIC_SELECT_FROM)->EnableWindow(true);
		GetDlgItem(IDC_EDIT_WHERE_CLAUSE)->EnableWindow(true);
		GetDlgItem(IDC_STATIC_IMPORT_SETTINGS)->EnableWindow(true);
		GetDlgItem(IDC_BTN_SAVE_QUERY)->EnableWindow(true);
		GetDlgItem(IDC_BTN_LOAD_QUERY)->EnableWindow(true);

		int nNbSelection=m_listFeatures.GetSelCount();

		GetDlgItem(IDOK)->EnableWindow(true);

		GetDlgItem(IDC_BTN_VIEW_SQL)->EnableWindow(true);
		GetDlgItem(IDC_BTN_DESCRIBE_OD_TABLE)->EnableWindow(true);
		GetDlgItem(IDC_EDIT_TABLENAME)->EnableWindow(true);
	}
	else
	{
		GetDlgItem(IDC_STATIC_CONDITION_SAMPLES)->EnableWindow(false);
		GetDlgItem(IDC_LIST_CONDITION_SAMPLES)->EnableWindow(false);
		GetDlgItem(IDC_STATIC_WHERE_CLAUSE)->EnableWindow(false);
		GetDlgItem(IDC_EDIT_WHERE_CLAUSE)->EnableWindow(false);
		GetDlgItem(IDC_STATIC_SELECT_FROM)->EnableWindow(false);
		GetDlgItem(IDC_STATIC_IMPORT_SETTINGS)->EnableWindow(false);
		GetDlgItem(IDC_BTN_SAVE_QUERY)->EnableWindow(false);
		GetDlgItem(IDC_BTN_LOAD_QUERY)->EnableWindow(false);
		GetDlgItem(IDOK)->EnableWindow(false);
		GetDlgItem(IDC_BTN_VIEW_SQL)->EnableWindow(false);
		GetDlgItem(IDC_BTN_DESCRIBE_OD_TABLE)->EnableWindow(false);
		GetDlgItem(IDC_EDIT_TABLENAME)->EnableWindow(false);
	}
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::OnBtnConnect() 
{
	AcMapFlatOrclApiTestConnectDlg Dlg;
	Dlg.DoModal();

	UpdateServiceSchema();
	UpdateControls();
	UpdateData(false);

	OnSelchangeListOdCondition();
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::OnBtnLoadQuery() 
{
	AcMapOSEQuery query(*AcMapOSEGetConnection());
	AcMapFlatOrclApiTestLoadQueryDlg Dlg;
	if (IDOK==Dlg.DoModal())
	{
		if (!query.Load((const char*)Dlg.m_strQueryName))
		{
			AfxMessageBox("Problem when reading the query");
			return;
		}

		std::string strQuery;
		strQuery=query.ConvertToSqlString();

		//we display the loaded query
		//in a separate dialog box to the user
		//we cannot initialize the present UI as there is only one edit control
		//for the where clause
		//The current query may have many features in it and each one may have custom 
		//conditions that we would be unable to display here
		AcMapFlatOrclApiTestViewSqlDlg Dlg("Loaded SQL Statement", strQuery);
		Dlg.DoModal();
		m_strEditWhereClause="";
		m_nIdConditionSample=-1;

		GetDlgItem(IDC_STATIC_WHERE_CLAUSE)->EnableWindow(true);
		GetDlgItem(IDC_EDIT_WHERE_CLAUSE)->EnableWindow(true);
		GetDlgItem(IDC_STATIC_SELECT_FROM)->EnableWindow(true);
		UpdateData(false);
	}
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::OnBtnSaveQuery() 
{
	UpdateData(true);

	if (m_strEditWhereClause.IsEmpty())
	{
		AfxMessageBox("Where clause not defined yet");
		return;
	}

	//We create a query object AcMapOSEQuery from the currently selected features
	//for each feature we create a sub query inside the AcMapOSEQuery
	//So the condition entered by the user is added and is common to each feature
	std::vector<std::string> vectFeatureNames;
	int nNbSelection=GetSelectedFeatures(vectFeatureNames);
	AcMapOSEQuery query(*AcMapOSEGetConnection());
	query.AddWhereConditionInFeatures(
		vectFeatureNames,
		(const char*)m_strEditWhereClause,
		true);

	//we ask for a query name before saving the query
	AcMapFlatOrclApiTestDisplayTextDlg Dlg(
		"Save the query",
		"Query Name",
		"");
	if (IDOK==Dlg.DoModal())
	{
		if (!query.Save((const char*)Dlg.m_strText))
		{
			AfxMessageBox("Problem when saving the query");
		}
	}
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::OnBtnViewSql() 
{
	UpdateData(true);

	if (m_strEditWhereClause.IsEmpty())
	{
		AfxMessageBox("Where clause not defined yet");
		return;
	}

	//We create a query object AcMapOSEQuery from the currently selected features
	//for each feature we create a sub query inside the AcMapOSEQuery
	//So the condition entered by the user is added and is common to each feature
	std::vector<std::string> vectFeatureNames;
	int nNbSelection=GetSelectedFeatures(vectFeatureNames);
	AcMapOSEQuery query(*AcMapOSEGetConnection());
	query.AddWhereConditionInFeatures(
		vectFeatureNames,
		(const char*)m_strEditWhereClause,
		true);

	AcMapFlatOrclApiTestViewSqlDlg Dlg("View SQL Statement", query.ConvertToSqlString());
	Dlg.DoModal();
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::OnSelchangeListOdCondition() 
{
	UpdateData(true);	
	m_strEditWhereClause=m_vectSqlWhereClauses[m_nIdConditionSample];
	UpdateData(false);
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::OnOK() 
{
	UpdateData(true);

	if (m_strEditWhereClause.IsEmpty())
	{
		AfxMessageBox("Where clause not defined yet");
		return;
	}

	//We create a query object AcMapOSEQuery from the currently selected features
	//for each feature we create a sub query inside the AcMapOSEQuery
	//So the condition entered by the user is added and is common to each feature
	std::vector<std::string> vectFeatureNames;
	int nNbSelection=GetSelectedFeatures(vectFeatureNames);
	AcMapOSEQuery query(*AcMapOSEGetConnection());
	query.AddWhereConditionInFeatures(
		vectFeatureNames,
		(const char*)m_strEditWhereClause,
		true);

	//we run the import based on the query we have just created
	AcMapOSEImport import(*AcMapOSEGetConnection());
	BeginWaitCursor();
	if (!import.Import(query))
	{
		EndWaitCursor();
		AfxMessageBox("The execution of the query failed");
		return;
	}
	EndWaitCursor();

	CDialog::OnOK();
}


//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::OnBtnDescribeOdTable() 
{
	//the user may want to describe any type of table in the current schema
	UpdateData(true);
	AcMapFlatOrclApiTestDescribeTableDlg Dlg(m_strTableName, this);
	Dlg.DoModal();
}

//******************************************************************************************
void AcMapFlatOrclApiTestImportDlg::OnSelchangeListFeatures() 
{
	UpdateData(TRUE);
	int nNbSelection=m_listFeatures.GetSelCount();

	//if only one feature is selected we update the static control
	//above the edit control of the where clause
	//with a query corresponding to this feature
	//We actually only display the "select ... from ... where" part
	//of the query
	if (1==nNbSelection)
	{
		GetDlgItem(IDC_BTN_FEATURE_ALIASES)->EnableWindow(true);

		std::vector<std::string> vectFeatureNames;
		int nNbSelection=GetSelectedFeatures(vectFeatureNames);
		assert (1==nNbSelection);

		AcMapOSEQuery query(*AcMapOSEGetConnection());
		//we add a dummy condition to be able to generate the SQL statement
		//because if no condition, no query is generated for any feature
		//and so, no statement is available
		query.AddWhereConditionInFeatures(
			vectFeatureNames,
			"dummy condition",
			true);
		std::string strQuery=query.ConvertToSqlString();
		int nPosWhere=strQuery.find("where ");
		assert(std::string::npos!=nPosWhere);
		m_strSelectFromWhere=strQuery.substr(0, nPosWhere+6).c_str();
	}
	//many features, we display a meaning that we are completing the where clause
	//but not specialized to any feature as we have many features selected
	else
	{
		GetDlgItem(IDC_BTN_FEATURE_ALIASES)->EnableWindow(false);

		m_strSelectFromWhere.Format(
			m_strSelect.c_str(),
			AcMapOSEGetConnection()->UserName());
	}
	UpdateData(FALSE);
}

//******************************************************************************************
// Returns the number of selected features

int AcMapFlatOrclApiTestImportDlg::GetSelectedFeatures(
	std::vector<std::string>& vectFeatureNames) //ouput vector of the selected fature in the listbox
{
	int nNbSelection=m_listFeatures.GetSelCount();

	if (nNbSelection>0)
	{
		int *pnSelectionIds=new int[nNbSelection];
		CString strFeatureName;

		vectFeatureNames.clear();
		m_listFeatures.GetSelItems(nNbSelection, pnSelectionIds);
		for (int i=0; i<nNbSelection; i++)
		{
			m_listFeatures.GetText(pnSelectionIds[i], strFeatureName);
			vectFeatureNames.push_back((const char*)strFeatureName);
		}
		delete[] pnSelectionIds;
	}
	return nNbSelection;
}

//******************************************************************************************
// For a given feature, a user can display the aliases of the tables that compose the feature
// This aliases will be used in the query to identify each table
// As the corresponding button is enabled when only one feature is selected
// this is just called for one selected feature

void AcMapFlatOrclApiTestImportDlg::OnBtnFeatureAliases() 
{
	std::vector<std::string> vectFeatureNames;
	int nNbSelection=GetSelectedFeatures(vectFeatureNames);
	assert (1==nNbSelection);

	std::vector<std::string> vectTableNames;
	std::vector<std::string> vectAliases;

	//generates a query for a single feature
	//and extracts the aliases
	AcMapOSEQuery query(*AcMapOSEGetConnection());
	bool bAliases=query.GetAliases(
			vectFeatureNames[0],
			vectTableNames,
			vectAliases);
	assert(vectTableNames.size()==vectAliases.size());

	std::string strListValues;
	for (int i=0; i<vectTableNames.size(); ++i)
	{
		strListValues+=vectTableNames[i];
		strListValues+="\t";
		strListValues+=vectAliases[i];
		strListValues+="\r\n";
	}

	AcMapFlatOrclApiTestDisplayTextDlg Dlg(
		"Feature Table Aliases",
		"Table name / Corresponding alias in the query",
		strListValues);
	Dlg.DoModal();
}
